/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.batch;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.JythonUtil;
import org.autoplot.RunBatchTool;
import org.autoplot.ScriptContext2023;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.Param;
import org.autoplot.jythonsupport.ui.Util;
import org.das2.components.DasProgressPanel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.python.util.InteractiveInterpreter;

public class BatchProcessor {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.runbatch");
    private int threads = 8;
    public static final String PROP_THREADS = "threads";
    private String writePngTemplate = "";
    public static final String PROP_WRITEPNGTEMPLATE = "writePngTemplate";
    private String statusMessage = "";
    public static final String PROP_STATUSMESSAGE = "statusMessage";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private static String[] maybeSplitMultiParam(String param) {
        if (param.contains("|")) {
            return param.split("\\|", -2);
        }
        if (param.contains(",")) {
            return param.split(",", -2);
        }
        if (param.contains(";")) {
            return param.split(";", -2);
        }
        return null;
    }

    private static void setParam(InteractiveInterpreter interp, String pwd, Param paramDescription, String paramName, String f1) throws IOException {
        if (paramDescription == null) {
            throw new IllegalArgumentException("expected to see parameter description!");
        }
        switch (paramDescription.type) {
            case 'R': 
            case 'U': {
                if (f1.startsWith("'") && f1.endsWith("'") && f1.length() > 1) {
                    f1 = f1.substring(1, f1.length() - 1);
                }
                URISplit split = URISplit.parse((String)f1);
                URI uri = split.path == null ? DataSetURI.getResourceURI((String)(pwd + f1)) : DataSetURI.getResourceURI((String)f1);
                interp.set("_apuri", (Object)uri);
                interp.exec("autoplot2025.params['" + paramName + "']=_apuri");
                break;
            }
            case 'L': {
                interp.exec("autoplot2025.params['" + paramName + "']=URL('" + f1 + "')");
                break;
            }
            case 'M': {
                interp.exec("from java.io import File");
                interp.exec("autoplot2025.params['" + paramName + "']=File('" + f1 + "')");
                break;
            }
            case 'A': {
                if (f1.startsWith("'") && f1.endsWith("'") && f1.length() > 1) {
                    f1 = f1.substring(1, f1.length() - 1);
                }
                interp.exec("autoplot2025.params['" + paramName + "']='" + f1 + "'");
                break;
            }
            case 'T': {
                try {
                    DatumRange timeRange = DatumRangeUtil.parseTimeRange((String)f1);
                    interp.set("_apdr", (Object)timeRange);
                    interp.exec("autoplot2025.params['" + paramName + "']=_apdr");
                }
                catch (ParseException ex) {
                    Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                interp.exec("autoplot2025.params['" + paramName + "']=" + f1);
            }
        }
    }

    private String doWrite(String template, String f1, String f2, String uri, Application dom) throws IOException {
        String[] ss;
        Preferences prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        prefs.put("lastTemplate", template);
        template = template.replaceAll("\\$x", "%s");
        f1 = f1.replaceAll("/", "_");
        f2 = f2.replaceAll("/", "_");
        f1 = f1.replaceAll(" ", "_");
        f2 = f2.replaceAll(" ", "_");
        f1 = f1.replaceAll(":", "_");
        f2 = f2.replaceAll(":", "_");
        ArrayList<String> argList = new ArrayList<String>();
        if (f1.contains(";")) {
            for (String s : ss = f1.split("\\;", -2)) {
                argList.add(s);
            }
        } else if (f1.trim().length() > 0) {
            argList.add(f1);
        }
        if (f2.contains(";")) {
            for (String s : ss = f2.split("\\;", -2)) {
                argList.add(s);
            }
        } else if (f2.trim().length() > 0) {
            argList.add(f2);
        }
        ss = template.split("\\%");
        boolean packArgments = false;
        if (argList.size() != ss.length - 1) {
            if (ss.length == 3) {
                packArgments = true;
            } else {
                throw new IllegalArgumentException("PNG template and number of parameters don't match");
            }
        }
        Object[] args = new Object[argList.size()];
        block6: for (int i = 0; i < argList.size(); ++i) {
            int c;
            String spec = packArgments ? "x" : ss[i + 1];
            int idx = 0;
            int n = c = spec.length() > 0 ? (int)spec.charAt(0) : 32;
            while (idx < spec.length() && (c == 45 || c == 46 || Character.isDigit((char)c))) {
                c = spec.length() > 0 ? (int)spec.charAt(++idx) : 32;
            }
            if (idx == spec.length()) {
                throw new IllegalArgumentException("expected to see non-digit in template after %");
            }
            char letter = spec.charAt(idx);
            if (letter == 's') {
                args[i] = argList.get(i);
                continue;
            }
            switch (letter) {
                case 'd': {
                    args[i] = Integer.parseInt((String)argList.get(i));
                    continue block6;
                }
                case 'e': 
                case 'f': {
                    args[i] = Double.parseDouble((String)argList.get(i));
                    continue block6;
                }
                default: {
                    args[i] = argList.get(i);
                }
            }
        }
        String s = packArgments ? String.format(template, f1, f2) : String.format(template, args);
        if ((s = s.replaceAll(" ", "_")).endsWith(".png")) {
            BufferedImage bufferedImage = dom.getController().getScriptContext().writeToBufferedImage();
            LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
            metadata.put("ScriptURI", uri);
            metadata.put("plotInfo", dom.getController().getApplicationModel().getCanvas().getImageMetadata());
            dom.getController().getScriptContext().writeToPng(bufferedImage, s, metadata);
        } else if (s.endsWith(".pdf")) {
            dom.getController().getScriptContext().writeToPdf(s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject doOneJob(String pwd, String scriptUri, String script, Map<String, Param> parameterDescriptions, Map<String, String> params, String param1Name, String param1Value, String param2Name, String param2Value, String doWriteTemplate, final ProgressMonitor monitor) throws RuntimeException {
        URISplit split = URISplit.parse((String)scriptUri);
        String name = split.file;
        param1Value = param1Value.trim();
        param1Name = param1Name.trim();
        JSONObject runResults = new JSONObject();
        try {
            ApplicationModel appmodel = new ApplicationModel();
            appmodel.addDasPeersToAppAndWait();
            Application myDom = appmodel.getDom();
            ScriptContext2023 scriptContext = new ScriptContext2023();
            myDom.getController().setScriptContext(scriptContext);
            if (!scriptContext.isModelInitialized()) {
                scriptContext.setApplicationModel(appmodel);
            }
            myDom.getController().getScriptContext();
            NullProgressMonitor myMonitor = new NullProgressMonitor(){

                public boolean isCancelled() {
                    return monitor.isCancelled();
                }
            };
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, myDom, (ProgressMonitor)myMonitor);
            interp.exec(JythonRefactory.fixImports((String)"import autoplot2025"));
            LinkedHashMap<String, String> scriptParams = new LinkedHashMap<String, String>();
            scriptParams.putAll(params);
            if (monitor.isCancelled()) {
                return null;
            }
            interp.set("PWD", (Object)split.path);
            String[] paramNames1 = BatchProcessor.maybeSplitMultiParam(param1Name);
            if (paramNames1 != null) {
                char splitc = param1Name.charAt(paramNames1[0].length());
                String[] paramValues = param1Value.trim().split("\\" + splitc);
                for (int j = 0; j < paramNames1.length; ++j) {
                    String p = paramNames1[j].trim();
                    String v = paramValues[j].trim();
                    if (!parameterDescriptions.containsKey(p)) {
                        if (p.trim().length() == 0) {
                            throw new IllegalArgumentException("param1Name not set");
                        }
                        throw new IllegalArgumentException("param not found: " + p);
                    }
                    BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(p), p, v);
                    runResults.put(p, (Object)v);
                    scriptParams.put(p, v);
                }
            } else {
                if (!parameterDescriptions.containsKey(param1Name) && param1Name.length() == 0) {
                    throw new IllegalArgumentException("param1Name not set");
                }
                for (Map.Entry<String, String> e : params.entrySet()) {
                    String pname = e.getKey();
                    if (parameterDescriptions.get(pname) == null) continue;
                    BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(pname), pname, e.getValue());
                }
                BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(param1Name), param1Name, param1Value);
                runResults.put(param1Name, (Object)param1Value);
                scriptParams.put(param1Name, param1Value);
            }
            if (param2Name != null && param2Name.length() > 0) {
                String[] paramNames2 = BatchProcessor.maybeSplitMultiParam(param2Name);
                if (paramNames2 != null) {
                    char splitc = param2Name.charAt(paramNames2[0].length());
                    String[] paramValues = param2Value.trim().split("\\" + splitc);
                    for (int j = 0; j < paramNames2.length; ++j) {
                        String p = paramNames2[j].trim();
                        String v = paramValues[j].trim();
                        if (!parameterDescriptions.containsKey(p)) {
                            if (p.trim().length() == 0) {
                                throw new IllegalArgumentException("param1Name not set");
                            }
                            throw new IllegalArgumentException("param not found: " + p);
                        }
                        BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(p), p, v);
                        runResults.put(p, (Object)v);
                        scriptParams.put(p, v);
                    }
                } else {
                    if (!parameterDescriptions.containsKey(param2Name) && param2Name.length() == 0) {
                        throw new IllegalArgumentException("param1Name not set");
                    }
                    for (Map.Entry<String, String> e : params.entrySet()) {
                        String pname = e.getKey();
                        if (parameterDescriptions.get(pname) == null) continue;
                        BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(pname), pname, e.getValue());
                    }
                    BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(param2Name), param2Name, param2Value);
                    runResults.put(param2Name, (Object)param2Value);
                    scriptParams.put(param2Name, param2Value);
                }
            }
            long t0 = System.currentTimeMillis();
            ByteArrayOutputStream outbaos = new ByteArrayOutputStream();
            try {
                interp.setOut((OutputStream)outbaos);
                interp.execfile((InputStream)new ByteArrayInputStream(script.getBytes("US-ASCII")), name);
                String uri = URISplit.format((String)"script", (String)split.resourceUri.toString(), scriptParams);
                if (doWriteTemplate.length() > 0) {
                    runResults.put("writeFile", (Object)this.doWrite(doWriteTemplate, param1Value, "", uri, myDom));
                }
            }
            catch (IOException | RuntimeException | JSONException ex) {
                String msg = ex.toString();
                runResults.put("result", (Object)msg);
            }
            finally {
                outbaos.close();
                runResults.put("stdout", (Object)new String(outbaos.toByteArray(), "US-ASCII"));
                runResults.put("executionTime", System.currentTimeMillis() - t0);
                System.out.println(runResults.getString("stdout"));
            }
            JSONObject copy = new JSONObject(runResults, JSONObject.getNames((JSONObject)runResults));
            return copy;
        }
        catch (RuntimeException ex) {
            Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IOException | JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        int oldThreads = this.threads;
        this.threads = threads;
        this.propertyChangeSupport.firePropertyChange(PROP_THREADS, oldThreads, threads);
    }

    public String getWritePngTemplate() {
        return this.writePngTemplate;
    }

    public void setWritePngTemplate(String writePngTemplate) {
        String oldWritePngTemplate = this.writePngTemplate;
        this.writePngTemplate = writePngTemplate;
        this.propertyChangeSupport.firePropertyChange(PROP_WRITEPNGTEMPLATE, oldWritePngTemplate, writePngTemplate);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        this.propertyChangeSupport.firePropertyChange(PROP_STATUSMESSAGE, null, statusMessage);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBatchScript(Application dom, String batchFile, ProgressMonitor monitor) throws IOException {
        int initialThreadCount = this.threads;
        try {
            int numberOfJobs;
            String[] param2Values;
            String[] param1Values;
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalArgumentException("don't call from event thread");
            }
            URISplit split = URISplit.parse((String)batchFile);
            String pwd = split.path;
            File f = DataSetURI.getFile((String)split.file);
            String batchFileJson = FileUtil.readFileToString((File)f);
            JSONObject jo = new JSONObject(batchFileJson);
            HashMap<String, String> params = new HashMap<String, String>();
            String scriptUri = jo.getString("script");
            String fscriptUri = scriptUri = scriptUri.replaceAll("\\%\\{PWD\\}", pwd);
            URISplit scriptSplit = URISplit.parse((String)scriptUri);
            LinkedHashMap scriptParams = URISplit.parseParams((String)scriptSplit.params);
            File scriptFile = DataSetURI.getFile((String)fscriptUri);
            String script = FileUtil.readFileToString((File)scriptFile);
            params.put("script", fscriptUri);
            params.put("param1", jo.getString("param1"));
            params.put("param2", jo.getString("param2"));
            Object oparam1Values = jo.get("param1Values");
            if (oparam1Values instanceof String) {
                param1Values = ((String)oparam1Values).split("\n");
            } else if (oparam1Values instanceof JSONArray) {
                JSONArray jv1 = (JSONArray)oparam1Values;
                param1Values = new String[jv1.length()];
                for (int i = 0; i < jv1.length(); ++i) {
                    param1Values[i] = jv1.getString(i);
                }
            } else {
                throw new IllegalArgumentException("param1Values must be a string or string array");
            }
            Object oparam2Values = jo.get("param2Values");
            if (oparam2Values instanceof String) {
                param2Values = ((String)oparam2Values).split("\n");
                if (param2Values.length == 1 && param2Values[0].equals("")) {
                    param2Values = null;
                }
            } else if (oparam2Values instanceof JSONArray) {
                JSONArray jv2 = (JSONArray)oparam2Values;
                param2Values = new String[jv2.length()];
                for (int i = 0; i < jv2.length(); ++i) {
                    param2Values[i] = jv2.getString(i);
                }
            } else {
                throw new IllegalArgumentException("param2Values must be a string or string array");
            }
            AtomicInteger threadCounter = new AtomicInteger(0);
            ThreadFactory tf = r -> new Thread(r, "run-batch-" + threadCounter.incrementAndGet());
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(initialThreadCount, tf);
            ArrayDeque durationsMillis = new ArrayDeque();
            AtomicInteger I1 = new AtomicInteger(0);
            boolean showEta = "true".equals(System.getProperty("RunBatchTool.eta", "true"));
            int i1 = 0;
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("dom", dom);
            env.put("PWD", pwd);
            Map fparameterDescriptions = Util.getParams(env, (String)script, params, (ProgressMonitor)new NullProgressMonitor());
            if (param2Values == null) {
                numberOfJobs = param1Values.length;
                monitor.setTaskSize((long)numberOfJobs);
                monitor.started();
                for (int i = 0; i < param1Values.length; ++i) {
                    String fparam1 = jo.getString("param1");
                    String fparam1Value = param1Values[i];
                    LinkedHashMap fscriptParams = scriptParams;
                    JSONObject frunResults = new JSONObject();
                    Runnable runOne = () -> {
                        if (monitor.isCancelled()) {
                            return;
                        }
                        long t0 = System.currentTimeMillis();
                        JSONObject runResults = this.doOneJob(pwd, fscriptUri, script, fparameterDescriptions, fscriptParams, fparam1, fparam1Value, null, null, this.writePngTemplate, monitor.getSubtaskMonitor(fparam1));
                        if (showEta) {
                            durationsMillis.addLast(System.currentTimeMillis() - t0);
                        }
                        if (runResults == null) {
                            return;
                        }
                        Iterator keyIterator = runResults.keys();
                        while (keyIterator.hasNext()) {
                            String k = (String)keyIterator.next();
                            try {
                                frunResults.put(k, runResults.get(k));
                            }
                            catch (JSONException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                        }
                        if (monitor.isFinished()) {
                            logger.fine("monitor reports being finished though it shouldn't have been.");
                        } else {
                            monitor.setTaskProgress((long)I1.incrementAndGet());
                        }
                    };
                    executor.execute(runOne);
                    ++i1;
                }
            } else {
                throw new IllegalArgumentException("second parameter not supported");
            }
            long lastWrite = System.currentTimeMillis();
            long lastReport = System.currentTimeMillis();
            long messageNumber = 0L;
            File resultsFile = null;
            int exportResultsWritten = 0;
            while (!(executor.getActiveCount() == 0 && I1.intValue() == numberOfJobs || monitor.isCancelled())) {
                String report;
                long t = System.currentTimeMillis();
                if (resultsFile != null && t - lastWrite > 10000L) {
                    if (!resultsFile.getName().endsWith(".json")) {
                        File pendingResultsFile = new File(resultsFile.getAbsolutePath() + ".pending");
                        int completed = I1.intValue();
                        int count = completed - exportResultsWritten;
                        exportResultsWritten = completed;
                    }
                    lastWrite = t;
                }
                if (!showEta || t - lastReport <= 3000L) continue;
                while (durationsMillis.size() > 12) {
                    long completed = (Long)durationsMillis.removeFirst();
                }
                long timeFor12Jobs = 0L;
                double jobCount = 0.0;
                if (durationsMillis.size() >= 12) {
                    try {
                        Iterator it = durationsMillis.descendingIterator();
                        for (int i = 0; i < 12; ++i) {
                            timeFor12Jobs += ((Long)it.next()).longValue();
                            jobCount += 1.0;
                        }
                    }
                    catch (ConcurrentModificationException it) {
                        // empty catch block
                    }
                }
                if (++messageNumber % 4L > 0L) {
                    long jobsRemaining = executor.getTaskCount() - executor.getCompletedTaskCount();
                    if (jobCount > 0.0) {
                        Datum eta = Units.milliseconds.createDatum((double)(jobsRemaining * timeFor12Jobs) / jobCount / (double)executor.getCorePoolSize());
                        eta = DatumUtil.asOrderOneUnits((Datum)eta);
                        String seta = String.format("%.2f%s", eta.value(), eta.getUnits());
                        Datum avgDuration = Units.milliseconds.createDatum((double)timeFor12Jobs / jobCount);
                        avgDuration = DatumUtil.asOrderOneUnits((Datum)avgDuration);
                        String savgDuration = String.format("%.2f%s", avgDuration.value(), avgDuration.getUnits());
                        report = String.format("%d remaining, avg %s, eta %s", jobsRemaining, savgDuration, seta);
                    } else {
                        report = String.format("%d jobs, %d remaining", numberOfJobs, jobsRemaining);
                    }
                } else {
                    report = "Running jobs...";
                }
                this.setStatusMessage(report);
                lastReport = t;
            }
            if (monitor.isCancelled()) {
                executor.shutdownNow();
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(BatchProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (!monitor.isFinished()) {
                monitor.finished();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Application dom = new ScriptContext2023().getDocumentModel();
        String batchFile = "https://github.com/autoplot/dev/blob/master/demos/2019/20190726/runBatch.batch";
        DasProgressPanel monitor = DasProgressPanel.createFramed((String)"Run Batch");
        BatchProcessor processor = new BatchProcessor();
        processor.setWritePngTemplate("/tmp/ap/mypng_%08.1f.png");
        processor.setThreads(6);
        new BatchProcessor().runBatchScript(dom, batchFile, (ProgressMonitor)monitor);
    }
}

